#This function should run as an entity with the tag "obstacle"


#return if obstacle is disabled
execute if entity @s[tag=disabled] run return 0

#increase score
function astro_game:obstacles/actions/award_score

#Handle eggs
execute if entity @s[tag=egg] run function astro_game:obstacles/actions/egg/activate


#Handle collectable
execute if entity @s[tag=collectable] run function astro_game:obstacles/actions/collectable/activate

#Handle collectable portal
execute if entity @s[tag=collectable_portal] run function astro_game:obstacles/actions/collectable_portal/activate


#Handle boost portal
execute if entity @s[tag=boost_portal] run function astro_game:obstacles/actions/boost_portal/activate

#Handle shield portal
execute if entity @s[tag=shield_portal] run function astro_game:obstacles/actions/shield_portal/activate

#Handle shield portal
execute if entity @s[tag=laser_portal] run function astro_game:obstacles/actions/laser_portal/activate

#Handle red spaceship
execute if entity @s[tag=red_spaceship] positioned as @s run particle minecraft:explosion ~ ~ ~-5 5 5 5 5 30 force
execute if entity @s[tag=red_spaceship] if score enabled astro_game.obstacles matches 1 positioned as @s run playsound sounds:explosion_red master @a[tag=game_viewer] ~ ~ ~ 1 1 1

#Handle orange spaceship
execute if entity @s[tag=orange_spaceship] positioned as @s run particle minecraft:explosion ~ ~ ~-5 5 5 5 5 30 force
execute if entity @s[tag=orange_spaceship] if score enabled astro_game.obstacles matches 1 positioned as @s run playsound sounds:explosion_orange master @a[tag=game_viewer] ~ ~ ~ 1 1 1


#return if target shouldn't kill the player
execute if entity @s[tag=non_lethal_obstacle] run return 0

#return if the player has a shield
execute if score shield_fuel astro_game.powerups matches 1.. run return run function astro_game:obstacles/actions/shield_portal/deactivate

execute if score preset astro_game.persistent matches 0 run return run function astro_game:obstacles/actions/spawning_presets/tutorial/failed_stage

#Play explosion particles on spaceship

execute as @e[tag=spaceship_body] positioned as @s run particle minecraft:explosion ~ ~ ~-5 5 5 5 2 5 force

#return if started death sequence
execute if score enabled astro_game.obstacles matches 0 run return 0

#Freeze obstacles
scoreboard players set enabled astro_game.obstacles 0

#Disable controls
scoreboard players set enabled astro_game.controls 0

#Death sound
playsound sounds:crash master @a[tag=game_viewer] ~ ~ ~ 1 1 1

#Death title
title @a[tag=game_viewer] times 25t 35t 5t
title @a[tag=game_viewer] subtitle {text:"\uF830",font:"minecraft:al",type:"text"}
title @a[tag=game_viewer] title [{font:"al",text:"\uF858",type:"text"}]




#End game after 3 seconds
schedule function astro_game:game/end 60t replace